% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cv.rgam.R
\name{print.cv.rgam}
\alias{print.cv.rgam}
\title{Print a cross-validated rgam object}
\usage{
\method{print}{cv.rgam}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{Fitted \code{rgam} object.}

\item{digits}{Significant digits in printout.}

\item{...}{Additional print arguments.}
}
\description{
Print a summary of the results of cross-validation for a RGAM model.
}
\details{
The call that produced the object x is printed, followed by some information
on the performance for \code{lambda.min} and \code{lambda.1se}.
}
\examples{
set.seed(1)
n <- 100; p <- 20
x <- matrix(rnorm(n * p), n, p)
beta <- matrix(c(rep(2, 5), rep(0, 15)), ncol = 1)
y <- x \%*\% beta + rnorm(n)
cvfit <- cv.rgam(x, y)
print(cvfit)

}
\seealso{
\code{\link{cv.rgam}}, \code{\link{print.rgam}}.
}
