% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rema-package.R, R/rema.R
\docType{package}
\name{rema}
\alias{rema}
\title{A permutation-based approach for heterogeneous meta-analyses of rare events}
\usage{
rema(
  trt.events = NULL,
  trt.total = NULL,
  ctrl.events = NULL,
  ctrl.total = NULL,
  rema.obj,
  mid.p = TRUE,
  distr = TRUE,
  one.sided.p = FALSE,
  alpha = 0.05
)
}
\arguments{
\item{trt.events}{Numeric vector containing the number of observed events in
the treatment group from each independent study.}

\item{trt.total}{Numeric vector containing the total number of observations
(events plus non-events) in the treatment group from each independent study.}

\item{ctrl.events}{Numeric vector containing the number of observed events in
the control group from each independent study.}

\item{ctrl.total}{Numeric vector containing the total number of observations
(events plus non-events) in the control group from each independent study.}

\item{rema.obj}{An object of class \code{rema} that contains the permutational distribution
of the test statistic. If this argument is supplied, the trt.events, trt.total,
ctrl.events, and ctrl.total vectors are not required.}

\item{mid.p}{A logical indicating if the p-values and confidence interval are
adjusted using the mid-p correction to reduce conservatism. If \code{TRUE}
(default), the mid-p p-values and mid-p confidence interval will be
reported.}

\item{distr}{A logical indicating if the permutational distribution of the
test statistic is reported. If \code{TRUE} (default), the distribution
is returned.}

\item{one.sided.p}{A logical indicating if the one-sided p-value (in the
direction of the treatment effect) is computed and returned. If
\code{FALSE} (default), the one-sided p-value is not provided.}

\item{alpha}{A number between 0 and 1 to create a (1 - alpha)\% confidence
interval for the treatment effect.}
}
\value{
An object of \code{\link{class}} "\code{rema}" with corresponding
\code{print}, \code{summary}, and \code{plot} (if \code{distr == TRUE})
functions. The object is a list containing the following elements:
\tabular{ll}{
\code{ trt.events} \tab As defined above. \cr
\code{trt.total} \tab As defined above. \cr
\code{ctrl.events} \tab As defined above. \cr
\code{ctrl.total} \tab As defined above. \cr
\code{mid.p} \tab As defined above. \cr
\code{alpha} \tab As defined above. \cr
\code{arguments} \tab A string of the arguments passed into \code{rema}. \cr
\code{TE} \tab The estimated overall treatment effect (odds ratio). \cr
\code{CI} \tab A vector containing the estimated lower and upper
bounds of a (1 - alpha)\% \cr
\tab confidence interval of the
overall treatment effect (odds ratio). \cr
\code{method} \tab A string specifying the method used to compute
the odds ratio and its associated \cr
\tab confidence
interval. Either the conditional maximum likelihood
estimate (CMLE) \cr
\tab or the median unbiased estimate (MUE)
will be used. \cr
\code{pval} \tab The two-sided p-value for the overall treatment effect. \cr
\code{pval.one.sided} \tab The one-sided p-value (in the direction of
the treatment effect) for the
overall \cr
\tab treatment effect (if
\code{one.sided.p == TRUE}). \cr
\code{dist} \tab A data frame containing the permutational
distribution of the test statistic \cr
\tab (if
\code{distr == TRUE}). \cr
\code{tstat} \tab The observed value of the test statistic (if
\code{distr == TRUE}). \cr
}
}
\description{
\code{rema} (rare event meta-analysis) performs a permutation-based
meta-analysis for heterogeneous, rare event data.
}
\details{
Conventional meta-analysis approaches tend to perform poorly for
heterogeneous, rare event data. \code{rema} implements a permutation-based
approach for binary meta-analyses of 2x2 tables, founded on conditional
logistic regression, that provides more reliable statistical tests when
heterogeneity is observed in rare event data
\insertCite{Zabriskie2021}{rema}. To adjust for the effect of heterogeneity,
this method conditions on the sufficient statistic of a proxy for the
heterogeneity effect as opposed to estimating the heterogeneity variance.
While this results in the model not strictly falling under the random-effects
framework, it is akin to a random-effects approach in that it assumes
differences in variability due to treatment. Further, this method does not
rely on large-sample approximations or continuity corrections for rare event
data.

This method uses the permutational distribution of the test statistic instead
of asymptotic approximations for inference. The number of observed events
drives the computation complexity for creating this permutational
distribution. Accordingly, for this method to be computationally feasible, it
should only be applied to meta-analyses with a relatively low number of
observed events. To create this permutational distribution, a network
algorithm, based on the work of \insertCite{Mehta1992;textual}{rema} and
\insertCite{Corcoran2001;textual}{rema}, is employed using C++ and integrated
into the package.

\insertNoCite{Normand1999}{rema}
}
\examples{
# Lidocaine data set from Normand (1999)
rema(trt.events = c(2, 4, 6, 7, 7, 11),
     trt.total = c(39, 44, 107, 103, 110, 154),
     ctrl.events = c(1, 4, 4, 5, 3, 4),
     ctrl.total = c(43, 44, 110, 100, 106, 146),
     mid.p = FALSE,
     distr = FALSE,
     one.sided.p = TRUE)

# Example using a rema object as the input once the permutational
# distribution is obtained
my.rema.object <- rema(trt.events = c(1, 2, 0, 2, 0, 0, 1, 0, 1, 0),
                       trt.total = c(30, 14, 30, 49, 38, 11, 31, 13, 49, 23),
                       ctrl.events = c(4, 3, 3, 0, 4, 4, 3, 2, 3, 4),
                       ctrl.total = c(15, 26, 42, 24, 40, 26, 47, 24, 27, 26),
                       mid.p = FALSE,
                       distr = TRUE,
                       one.sided.p = FALSE)
rema(rema.obj = my.rema.object,
     mid.p = TRUE)

\dontrun{
# Vectors of non-whole numbers (such as after applying a continuity correction)
rema(trt.events = c(0.5, 0.5, 1, 3),
     trt.total = c(2, 5, 4, 12),
     ctrl.events = c(2.5, 4.5, 6, 7),
     ctrl.total = c(7, 9, 11, 12))

# Vectors with greater observed events than total observations
rema(trt.events = c(11, 13, 7, 10),
     trt.total = c(10, 12, 5, 7),
     ctrl.events = c(22, 25, 32, 26),
     ctrl.total = c(20, 20, 30, 25))
}

}
\references{
\insertAllCited{}
}
\seealso{
\href{https://www.rdocumentation.org/packages/meta/versions/4.15-1/topics/metabin}{metabin} and
\href{https://www.rdocumentation.org/packages/metafor/versions/2.4-0/topics/metafor-package}{metafor}
for more traditional meta-analysis methods for combining odds ratios.
}
