% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-methods.R
\name{lemmy_get_banned_persons}
\alias{lemmy_get_banned_persons}
\title{Get a list of banned users}
\usage{
lemmy_get_banned_persons(
  auth,
  .lemmy_instance = getOption("lemmy_instance", "https://lemmy.world")
)
}
\arguments{
\item{auth}{A character value.}

\item{.lemmy_instance}{Default: "https://lemmy.world". Change the default instance by setting the \code{lemmy_instance} \code{\link[=options]{options()}}.}
}
\value{
A \code{list} of length 1:
\preformatted{<list>
`-banned: <list>
  `-[Each element]: <list>
    |-person: <list>
    | |-id: A numeric value
    | |-name: A character value
    | |-display_name: (Optional) A character value
    | |-avatar: (Optional) A character value
    | |-banned: A logical value
    | |-published: A character value
    | |-updated: (Optional) A character value
    | |-actor_id: A character value
    | |-bio: (Optional) A character value
    | |-local: A logical value
    | |-banner: (Optional) A character value
    | |-deleted: A logical value
    | |-inbox_url: A character value
    | |-matrix_user_id: (Optional) A character value
    | |-admin: A logical value
    | |-bot_account: A logical value
    | |-ban_expires: (Optional) A character value
    | `-instance_id: A numeric value
    `-counts: <list>
      |-id: A numeric value
      |-person_id: A numeric value
      |-post_count: A numeric value
      |-post_score: A numeric value
      |-comment_count: A numeric value
      `-comment_score: A numeric value
}
}
\description{
\code{HTTP.GET /user/banned}
}
