% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-methods.R
\name{lemmy_list_communities}
\alias{lemmy_list_communities}
\title{List communities, with various filters.}
\usage{
lemmy_list_communities(
  type_ = NULL,
  sort = NULL,
  show_nsfw = NULL,
  page = NULL,
  limit = NULL,
  auth = NULL,
  .lemmy_instance = getOption("lemmy_instance", "https://lemmy.world")
)
}
\arguments{
\item{type_}{(Optional) One of "All", "Local", or "Subscribed".}

\item{sort}{(Optional) One of "Active", "Hot", "New", "Old", "TopDay", "TopWeek", "TopMonth", "TopYear", "TopAll", "MostComments", "NewComments", "TopHour", "TopSixHour", "TopTwelveHour", "TopThreeMonths", "TopSixMonths", or "TopNineMonths".}

\item{show_nsfw}{(Optional) A logical value.}

\item{page}{(Optional) A numeric value.}

\item{limit}{(Optional) A numeric value.}

\item{auth}{(Optional) A character value.}

\item{.lemmy_instance}{Default: "https://lemmy.world". Change the default instance by setting the \code{lemmy_instance} \code{\link[=options]{options()}}.}
}
\value{
A \code{list} of length 1:
\preformatted{<list>
`-communities: <list>
  `-[Each element]: <list>
    |-community: <list>
    | |-id: A numeric value
    | |-name: A character value
    | |-title: A character value
    | |-description: (Optional) A character value
    | |-removed: A logical value
    | |-published: A character value
    | |-updated: (Optional) A character value
    | |-deleted: A logical value
    | |-nsfw: A logical value
    | |-actor_id: A character value
    | |-local: A logical value
    | |-icon: (Optional) A character value
    | |-banner: (Optional) A character value
    | |-followers_url: A character value
    | |-inbox_url: A character value
    | |-hidden: A logical value
    | |-posting_restricted_to_mods: A logical value
    | `-instance_id: A numeric value
    |-subscribed: One of "Subscribed", "NotSubscri...
    |-blocked: A logical value
    `-counts: <list>
      |-id: A numeric value
      |-community_id: A numeric value
      |-subscribers: A numeric value
      |-posts: A numeric value
      |-comments: A numeric value
      |-published: A character value
      |-users_active_day: A numeric value
      |-users_active_week: A numeric value
      |-users_active_month: A numeric value
      |-users_active_half_year: A numeric value
      `-hot_rank: A numeric value
}
}
\description{
\code{HTTP.GET /community/list}
}
\examples{
\dontshow{if (remmy:::is_lemmy_world()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
community_list <- lemmy_list_communities(sort = "TopMonth", limit = 1)

community_list$communities[[1]]$community$name
\dontshow{\}) # examplesIf}
}
