% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{psABB}
\alias{psABB}
\title{psABB}
\usage{
psABB()
}
\value{
List with all information required by `remstats::remstats()` to compute the statistic.
}
\description{
Specifies the statistic for a participation shift AB-B in the sender step of the actor-oriented model.
}
\details{
The AB-B participation shift refers to the tendency for immediate reciprocation (the next sender is the previous receiver). For each timepoint t, the psABBA statistic is equal to one for the actor (i.e, the previous event receiver) that will create the participation shift if it would occur as sender in the edgelist at time t and equal to zero for the actors that will not create this participation shift. If multiple events in the edgelist occur at the same time point, the order of these events determines whether the p-shift is observed.
}
\examples{
reh_actor <- remify::remify(history, model = "actor")
remstats(reh = reh_actor, sender_effects = ~ psABB())

}
\seealso{
\code{\link{psABA}} or \code{\link{psABX}} for exploring alternative participation shifts in the sender step of the actor-oriented model.
}
