% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_fillcodedcode.R
\name{ru_fillcodedcode}
\alias{ru_fillcodedcode}
\title{Fill missing code/decode records}
\usage{
ru_fillcodedcode(
  dsetin,
  codedecodevarpairs = NULL,
  varcodelistpairs = NULL,
  codelistnames = list(),
  groupbyvars = NULL,
  completetypes = TRUE
)
}
\arguments{
\item{dsetin}{The data set that will be counted to generate numerators for counts and percents.}

\item{codedecodevarpairs}{Specifies code and decode variable pairs. Those variables should be in parameter GROUPBYVARSNUMER.
One variable in the pair will contain the code, which is used in counting and ordering, and the other
will contain decode, which is used for presentation.}

\item{varcodelistpairs}{List of code/decode pairs of variables.}

\item{codelistnames}{List of decodes for use with decoding code/decode pairs.}

\item{groupbyvars}{Set of by-variables used to merge the incoming data set with the decode data set.}

\item{completetypes}{Keep all code/decode pairs even it not present on the incoming data set?}
}
\value{
A data frame based on the incoming data frame but with decode values added along with records when completetypes is true.
}
\description{
Pass in a data frame with along code/decode variables and values to have missings populated.
}
\examples{
library(repfun)
fmtlist <- list('SEXS'=list('START'=list('M','F'),
                'LABEL'=c('Male','Female')))
adsl <- repfun::adsl
adsl2 <- repfun::ru_fillcodedcode(adsl, codedecodevarpairs=c("SEX", "SEXDCD"),
                          varcodelistpairs=c("SEX", "SEXS"),
                          codelistnames=fmtlist)
unique(adsl2[c("SEX","SEXDCD")])

}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
