% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_libname.R
\name{ru_libname}
\alias{ru_libname}
\title{Automate retrieval of data sets/frames in specified folder.}
\usage{
ru_libname(datapath)
}
\arguments{
\item{datapath}{Location of reporting data sets.}
}
\value{
List of function calls for use in quickly accessing individual data sets/frames.
}
\description{
Provide a folder containing data sets/frames and have a list of function calls returned that can be used to quickly access individual data sets/frames.
}
\examples{
library(repfun)
datdir <- file.path(gsub("\\\\","/",tempdir(),fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
adamdata <- repfun::ru_libname(datdir)
adamdata$adae.rda() \%>\% dplyr::filter(TRTEMFL=='Y') -> teae
print(head(teae[,c(1:10)]),10)

}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
