% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Objects.R
\name{LoadObjects}
\alias{LoadObjects}
\title{LoadObjects}
\usage{
LoadObjects(params, env = .GlobalEnv, loadFiles)
}
\arguments{
\item{params}{A list of parameters. Should include the named items inputDir and inputFiles.}

\item{env}{An environment in which to load objects. Defaults to the global environment.}

\item{loadFiles}{A character vector of files containing saved data.}
}
\value{
Character vector containing the names of loaded objects.
}
\description{
This function will load a set of objects stored in .rda files. By default, objects are
loaded into the Global environment.
}
\details{
The params object is defined within an RMarkdown file and contains named items "inputDir" and "inputFiles".
As an expedient, one may pass a vector of filenames. This vector will only be used if the params argument has been
omitted.
}
\examples{
\dontrun{
loadedObjects <- LoadObjects(params)
}

}
