% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{testfunctionParameterChecks}
\alias{testfunctionParameterChecks}
\title{testfunctionParameterChecks}
\usage{
testfunctionParameterChecks(alternative, alpha, stderr)
}
\arguments{
\item{alternative}{The type of statistical test. Valid values are one of
c('two.sided', 'greater', 'less')}

\item{alpha}{The test level. Valid values are between 0.0001 and 0.2}

\item{stderr}{The standard error of a parameter whose confidence intervals
is to be calculated}
}
\value{
'Success' or an error message.
}
\description{
This is a helper function that ensures parameter values used
for performing special statistical tests are valid.
}
\examples{
#reproducer:::testfunctionParameterChecks(alternative='larger',alpha=0.1,stderr=0.002)
#Error in testfunctionParameterChecks(alternative = 'larger', alpha = 0.1) :
#  Invalid alternative parameter, choose one of two.sided, greater or less
reproducer:::testfunctionParameterChecks(alternative='greater',alpha=0.1,stderr=0.002)
#[1] 'Success'
#reproducer:::testfunctionParameterChecks(alternative='greater',alpha=0.1,stderr=0.000)
#Error in testfunctionParameterChecks(alternative = 'greater', alpha = 0.1,  :
#  Improbably small variance, data are essentially constant
}
\author{
Barbara Kitchenham and Lech Madeyski
}
