% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadTileAndUpload.R
\name{prepInputsWithTiles}
\alias{prepInputsWithTiles}
\title{Alternative to \code{prepInputs} that can use Spatial Tiles stored locally or on Google Drive}
\usage{
prepInputsWithTiles(
  targetFile,
  url,
  destinationPath,
  to,
  tilesFolder = file.path(getOption("reproducible.inputPath"), "tiles"),
  urlTiles = getOption("reproducible.prepInputsUrlTiles", NULL),
  doUploads = getOption("reproducible.prepInputsDoUploads", FALSE),
  tileGrid = "CAN",
  numTiles = NULL,
  plot.grid = FALSE,
  purge = FALSE,
  verbose = getOption("reproducible.verbose"),
  ...
)
}
\arguments{
\item{targetFile}{Character. Name of the target file to be downloaded or processed.
If missing, it will be inferred from the URL or Google Drive metadata.}

\item{url}{Character. URL to the full dataset (Google Drive or HTTP/S).}

\item{destinationPath}{Character. Path to the directory where files will be downloaded and processed.}

\item{to}{A spatial object (e.g., \code{SpatRaster}, \code{SpatVector}, \code{sf}, or \verb{Spatial*}) defining the area of interest.}

\item{tilesFolder}{A local file path to put tiles. If this is an absolute path, then
that will be used; if it is a relative path, then it will be
\code{file.path(destinationPath, tilesFolder)}}

\item{urlTiles}{Character. URL to the tile source (e.g., Google Drive folder or HTTP/S endpoint). Default is \code{getOption("reproducible.prepInputsUrlTiles", NULL)}.}

\item{doUploads}{Logical. Whether to upload processed tiles.
Default is \code{getOption("reproducible.prepInputsDoUploads", FALSE)}.}

\item{tileGrid}{Either length 3 character string, such as "CAN", to be sent to \code{geodata::gadm(...)}
or an actual \code{SpatVector} object with a grid of polygons}

\item{numTiles}{Integer. Number of tiles to generate. Optional.}

\item{plot.grid}{Logical. Whether to plot the tile grid and area of interest. Default is \code{FALSE}.}

\item{purge}{Logical or Integer. \code{0/FALSE} (default) keeps existing \code{CHECKSUMS.txt} file and
\code{prepInputs} will write or append to it. \code{1/TRUE} will deleted the entire \code{CHECKSUMS.txt} file.}

\item{verbose}{Logical or numeric. Controls verbosity of messages. Default is \code{getOption("reproducible.verbose")}.}

\item{...}{Either \code{maskTo}, \code{cropTo} (which will be used if \code{to} is not supplied, or
arguments passed to \code{writeRaster}, e.g., \code{datatype} (used when writing tiles).}
}
\value{
A single, merged \code{SpatRaster} object \code{postProcess}ed to the area of interest (\code{to}),
composed of the necessary tiles.
If the post-processed file already exists locally, it will be returned directly.
}
\description{
Downloads, processes and optionally uploads a \code{SpatRaster} object through a tiling intermediary.
If the original \code{url} is for a very large object, but \code{to} is a relatively small subset
of the area represented by the spatial file at \code{url}, then this function will
potentially by-pass the download of the large file at \code{url} and instead only download
the minimum number of tiles necessary to cover the \code{to} area. When \code{doUploads} is
TRUE, then this function will potentially create and upload the tiles to \code{tileFolder},
prior to returning the spatial object, \code{postProcess}ed to \code{to}. This function supports
both Google Drive and HTTP(S) URLs.
}
\details{
This function can be triggered \emph{inside} \code{prepInputs}
if the \code{to} is supplied and both \code{url} and \code{urlTiles} are supplied. \strong{NOTE}:
\code{urlTiles} can be supplied using the
\verb{option(reproducible.prepInputsUrlTiles = someGoogleDriveFolderURL}), so the original
\code{prepInputs} function call can remain unaffected.

This function also uses a different checksumming procedure compared to the normal \code{prepInputs}.
This function will assess the remote url for a hash. If that hash exists, then
it will compare it to a local file with \code{targetFile} name, suffixed with \code{.hash}. If the
two hashes differ (remote and local), then it will be redownloaded; otherwise the local
one will be returned.

This function is useful for working with large spatial datasets, but where the user
only requires a "relatively small" section of that dataset. This function will
potentially bypass the full download and download only the tiles that are necessary
for the \code{to}.
It handles downloading only the required tiles based on spatial intersection
with the target area, and supports resumable downloads from Google Drive or HTTP/S sources.

If \code{targetFile} is missing, the function attempts to infer it from the URL
using the \code{Content-Disposition} header or the basename of the URL.
For Google Drive URLs, it uses the file metadata.
}
\examples{

if (FALSE) {
  to <- sf::st_as_sf(sf::st_sfc(sf::st_point(c(-123.3656, 48.4284)), crs = 4326))
  result <- prepInputsWithTiles(
    url = "https://example.com/data.tif",
    destinationPath = tempdir(),
    to = to,
    urlTiles = "https://example.com/tiles/",
    tileGrid = "CAN"
  )
}

}
\seealso{
\code{\link[googledrive:drive_get]{googledrive::drive_get()}}, \code{\link[terra:rast]{terra::rast()}}, \code{\link[terra:crop]{terra::crop()}}, \code{\link[terra:merge]{terra::merge()}}
}
