% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_dot_product.R
\name{dot_product}
\alias{dot_product}
\title{Dot product similarity}
\usage{
dot_product(mats)
}
\arguments{
\item{mats}{A list of length \eqn{M} containing data matrices of size \eqn{(n_\mathrm{samples},\, p_k)}. All matrices must share the same number of rows for matching samples.}
}
\value{
An \eqn{M \times M} matrix of symmetric dot-product similarities.
}
\description{
Compute pairwise dot-product similarities between multiple representations.
}
\examples{
# --------------------------------------------------
# Use "iris" and "USArrests" datasets
#   1. apply scaling to reduce the effect of scales
#   2. add white noise to create multiple representations
#   3. generate 10 perturbations per each dataset
# --------------------------------------------------
# prepare the prototype
set.seed(1)
X = as.matrix(scale(as.matrix(iris[sample(1:150, 50, replace=FALSE),1:4])))
Y = as.matrix(scale(as.matrix(USArrests)))
n = nrow(X)
p_X = ncol(X)
p_Y = ncol(Y)

# generate 10 of each by perturbation
mats = vector("list", length=20L)
for (i in 1:10){
  mats[[i]] = X + matrix(rnorm(n*p_X, sd=1), nrow=n)
}
for (j in 11:20){
  mats[[j]] = Y + matrix(rnorm(n*p_Y, sd=1), nrow=n)
}

# compute similarity
sim_mat = dot_product(mats)

# visualize
opar <- par(no.readonly=TRUE)
labs <- paste0("rep ",1:20)
par(pty="s")
image(sim_mat[,20:1], axes=FALSE, main="Dot product similarity")
axis(1, seq(0, 1, length.out=20), labels = labs, las = 2)
axis(2, at = seq(0, 1, length.out=20), labels = labs[20:1], las = 2)
par(opar)

}
\references{
\insertRef{kornblith_2019_SimilarityNeuralNetwork}{repsim}
}
