% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.reslr_output.R
\name{plot.reslr_output}
\alias{plot.reslr_output}
\title{Plotting the results for each statistical model from the \code{reslr_mcmc} function.}
\usage{
\method{plot}{reslr_output}(
  x,
  plot_proxy_records = TRUE,
  plot_tide_gauges = FALSE,
  title = "",
  plot_type = c("model_fit_plot"),
  plot_caption = TRUE,
  xlab = "Year (CE)",
  ylab = "Relative Sea Level (m)",
  y_rate_lab = "Rate of change (mm per year)",
  ...
)
}
\arguments{
\item{x}{An object of class \code{reslr_output} and \code{model_type} created via \code{\link{reslr_mcmc}}}

\item{plot_proxy_records}{Plotting the proxy records on their own and this is the default}

\item{plot_tide_gauges}{Plotting the tide gauge data as well as proxy data}

\item{title}{Plotting a title on the output plots}

\item{plot_type}{The user can select the type of output plot they require from the following: "rate_plot", "model_fit_plot", "regional_plot", "regional_rate_plot", "linear_local_plot", "non_linear_local_plot", "non_linear_local_rate_plot", "nigam_component_plot"}

\item{plot_caption}{Plotting an informed caption with the number of tide gauges and proxy sites.}

\item{xlab}{Labeling the x-axis}

\item{ylab}{Labeling the y-axis}

\item{y_rate_lab}{Labeling the y-axis for rate of change plots}

\item{...}{Not used}
}
\value{
Plot of model fit and the rate of change depending on the statistical model in question.
}
\description{
Depending on the model chosen in the \code{reslr_mcmc} function, the package produces a range of output plots.
Total posterior model fit plot with the raw data and measurement uncertainty are created for each statistical model.
The rate of change plots are created for the EIV IGP and the NI spline regression models.
For the NI GAM decomposition, each individual component of the model is plotted. Also, the regional and the non-linear local component, an associated rate plot is produced.
If tide gauges are used in the model, the user has the ability plot the output with or without this additional data source.
}
\examples{
\donttest{
data <- NAACproxydata \%>\% dplyr::filter(Site == "Cedar Island")
x <- reslr_load(data = data)
jags_output <- reslr_mcmc(x, model_type = "eiv_slr_t")
plot(x = jags_output)}
}
