% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bronars.R
\name{bronars}
\alias{bronars}
\title{Computes the Bronars power index for a given axiom at a given efficiency level}
\usage{
bronars(p, q, simulation = 1000, model = "GARP", efficiency = 1)
}
\arguments{
\item{p}{A \eqn{T X N} matrix of observed prices where each row corresponds to an observation and each column
corresponds to a consumption category. \eqn{T} is the number of observations and \eqn{N} is the number of consumption
categories.}

\item{q}{A \eqn{T X N} matrix of observed quantities where each row corresponds to an observation and each column
corresponds to a consumption category.\eqn{T} is the number of observations and \eqn{N} is the number of consumption
categories.}

\item{simulation}{Specifies the number of repetitions required of the simulated random data. The default
value is 1000.}

\item{model}{Specifies which axiom (GARP, SARP, or WARP) should be used to compute the power. The default option
is "GARP".}

\item{efficiency}{The efficiency level \eqn{e} is a real number between 0 and 1 and allows for a
small margin of error. The default value is 1.}
}
\value{
The function returns the power of a given axiom against uniformly random behavior at a given efficiency level.
}
\description{
The power of the revealed preference test of a given axiom captures the probability of rejecting the
axiom if the data set is generated by irrational behavior. Following Bronars' (1987) approach, we measure power using
Becker's (1962) notion of irrational behavior. More specifically, we generate irrational behavior by
simulating a consumer who makes consumption choices randomly from his or her budget set such that the budget set is
exhausted. The Bronars power index captures the probability of rejecting the null hypothesis that the random choices are utility
maximizing. Essentially, Bronars' power index is the number of times a violation is detected in the
simulated data sets divided by the number of repetitions.
}
\section{References}{

\itemize{
\item Becker, Gary S. "Irrational behavior and economic theory." Journal of political economy 70,
no. 1 (1962): 1-13.
\item Bronars, Stephen G. "The power of nonparametric tests of preference maximization." Econometrica:
Journal of the Econometric Society (1987): 693-698.
}
}

\examples{
# define a price matrix
p = matrix(c(4,4,4,1,9,3,2,8,3,1,
8,4,3,1,9,3,2,8,8,4,
1,4,1,8,9,3,1,8,3,2),
nrow = 10, ncol = 3, byrow = TRUE)

# define a quantity matrix
q = matrix(c( 1.81,0.19,10.51,17.28,2.26,4.13,12.33,2.05,2.99,6.06,
5.19,0.62,11.34,10.33,0.63,4.33,8.08,2.61,4.36,1.34,
9.76,1.37,36.35, 1.02,3.21,4.97,6.20,0.32,8.53,10.92),
nrow = 10, ncol = 3, byrow = TRUE)

# compute Bronars power index for GARP at full efficiency
bronars(p,q)

# compute Bronars power index for SARP at e = 0.99
bronars(p,q, model = "SARP", efficiency = 0.99)

}
