% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfm-segment.R
\name{rfm_plot_segment_scatter}
\alias{rfm_plot_segment_scatter}
\title{Segment Scatter Plots}
\usage{
rfm_plot_segment_scatter(
  segments,
  x = "monetary",
  y = "recency",
  plot_title = NULL,
  legend_title = NULL,
  xaxis_label = NULL,
  yaxis_label = NULL,
  interactive = FALSE,
  animate = FALSE,
  print_plot = TRUE
)
}
\arguments{
\item{segments}{Output from \code{rfm_segment}.}

\item{x}{Metric to be represented on X axis.}

\item{y}{Metric to be represented on Y axis.}

\item{plot_title}{Title of the plot.}

\item{legend_title}{Title of the plot legend.}

\item{xaxis_label}{X axis label.}

\item{yaxis_label}{Y axis label.}

\item{interactive}{If \code{TRUE}, uses \code{plotly} as the visualization
engine. If \code{FALSE}, uses \code{ggplot2}.}

\item{animate}{If \code{TRUE}, animates the bars. Defaults to \code{FALSE}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a
plot object.}
}
\value{
Scatter plot.
}
\description{
Generate scatter plots to examine the relationship between
recency, frequency and monetary value.
}
\examples{
# analysis date
analysis_date <- as.Date('2006-12-31')

# generate rfm score
rfm_result <- rfm_table_order(rfm_data_orders, customer_id, order_date,
revenue, analysis_date)

# segment names
segment_names <- c("Champions", "Potential Loyalist", "Loyal Customers",
                   "Promising", "New Customers", "Can't Lose Them",
                   "At Risk", "Need Attention", "About To Sleep", "Lost")

# segment intervals
recency_lower <-   c(5, 3, 2, 3, 4, 1, 1, 1, 2, 1)
recency_upper <-   c(5, 5, 4, 4, 5, 2, 2, 3, 3, 1)
frequency_lower <- c(5, 3, 2, 1, 1, 3, 2, 3, 1, 1)
frequency_upper <- c(5, 5, 4, 3, 3, 4, 5, 5, 3, 5)
monetary_lower <-  c(5, 2, 2, 3, 1, 4, 4, 3, 1, 1)
monetary_upper <-  c(5, 5, 4, 5, 5, 5, 5, 5, 4, 5)

# generate segments
segments <- rfm_segment(rfm_result, segment_names, recency_lower,
recency_upper, frequency_lower, frequency_upper, monetary_lower,
monetary_upper)

# visualize
# ggplot2
rfm_plot_segment_scatter(segments, "monetary", "recency")

# plotly
rfm_plot_segment_scatter(segments, "monetary", "recency", interactive = TRUE)

}
