% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regions.R
\name{gd_region}
\alias{gd_region}
\alias{gd_region_to_vect}
\title{Create GeoJSON Region from R Spatial Objects}
\usage{
gd_region(x)

gd_region_to_vect(x, crs = "OGC:CRS84", as_wkt = FALSE, ...)
}
\arguments{
\item{x}{list. A GeoJSON-like list object (e.g. from \code{gd_region()}).}

\item{crs}{character. Default for GeoJSON sources is \code{"OGC:CRS84"}.}

\item{as_wkt}{logical. Return Well-Known Text (WKT) string as character? Default: \code{FALSE} returns a 'terra' \emph{SpatVector}.}

\item{...}{Additional arguments to \code{gd_region_to_vect()} are passed to \code{terra::vect()} when \code{as_wkt=FALSE} (default).}
}
\value{
list representing a GeoJSON extent

\code{gd_region_to_vect()}: a 'terra' \emph{SpatVector} object, or \emph{character} containing Well-Known Text.
}
\description{
Creates a suitable input for the \code{region} argument to \verb{gd_download(<Image>)} or \code{gd_search()} for Image Collections.

\code{gd_region_to_vect()} is the inverse function of gd_region/gd_bbox; convert GeoJSON-like list to Well-Known Text(WKT)/\emph{SpatVector}. This may be useful, for example. when \code{gd_region()}-output was derived from an Earth Engine asset rather than local R object.
}
\details{
If \code{x} is an R spatial object, each vertex (possibly after converting object extent to vector) is used to create the GeoJSON object. Otherwise, the extent is determined and passed to \code{gd_bbox()}.

\code{gd_region_to_vect()} uses Python's \code{json} module (via \code{reticulate}) to parse the GeoJSON list and \code{terra} to create the spatial vector object. It supports all geometry types handled by \code{terra::vect} (e.g., Polygon, MultiPolygon).
}
\examples{
\dontshow{if (isTRUE(as.logical(Sys.getenv("R_RGEEDIM_RUN_EXAMPLES"))) && gd_is_initialized() && !inherits(requireNamespace("terra", quietly=TRUE), 'try-error')) withAutoprint(\{ # examplesIf}
\donttest{
library(terra)

b <- terra::vect('POLYGON((-121.355 37.560, 
                           -121.355 37.555,
                           -121.350 37.555, 
                           -121.350 37.560,
                           -121.355 37.560))',
                 crs = "OGC:CRS84")

gd_region(b)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{gd_bbox()}
}
