% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglobi.R
\name{get_prey_of}
\alias{get_prey_of}
\title{Get a List of Prey for given Predator Taxon}
\usage{
get_prey_of(taxon = "Homo sapiens", ...)
}
\arguments{
\item{taxon}{scientific name of predator taxon. Can be any taxonomic rank (e.g. Homo sapiens, Animalia)}

\item{...}{list of named options to configure GloBI API}
}
\value{
list of recorded predator-prey interactions that involve the desired predator taxon
}
\description{
Get a List of Prey for given Predator Taxon
}
\examples{
\donttest{
get_prey_of("Homo sapiens")
get_prey_of("Primates")
}
}
\seealso{
Other interactions: 
\code{\link{get_interaction_matrix}()},
\code{\link{get_interaction_types}()},
\code{\link{get_interactions_by_taxa}()},
\code{\link{get_interactions_by_type}()},
\code{\link{get_interactions}()},
\code{\link{get_predators_of}()}
}
\concept{interactions}
