% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gn_parse.R
\name{gn_parse}
\alias{gn_parse}
\title{gn_parse}
\usage{
gn_parse(
  x,
  threads = 1,
  batch_size = NULL,
  ignore_tags = FALSE,
  cultivar = FALSE,
  capitalize = FALSE,
  diaereses = FALSE,
  details = FALSE
)
}
\arguments{
\item{x}{(character) vector of scientific names. required}

\item{threads}{(integer/numeric) number of threads to run for parallel
processing. Setting to \code{NULL} will use all threads available. default: \code{1}}

\item{batch_size}{(integer/numeric) maximum number of names in a
batch send for processing. default: \code{NULL}}

\item{ignore_tags}{(logical) ignore HTML entities and tags when
parsing. default: \code{FALSE}}

\item{cultivar}{(logical) adds support for botanical cultivars like
\verb{Sarracenia flava 'Maxima'} and graft-chimaeras like \code{+ Crataegomespilus}.
default: \code{FALSE}}

\item{capitalize}{(logical) capitalizes the first letter of name-strings.
default: \code{FALSE}}

\item{diaereses}{(logical) preserves diaereses within names, e.g.
\verb{Leptochloöpsis virgata}. The stemmed canonical name will be generated
without diaereses. default: \code{FALSE}}

\item{details}{(logical) Return more details for a parsed name}
}
\value{
a list
}
\description{
extract names using gnparser
}
\examples{
trys <- function(x) try(x, silent=TRUE)
if (interactive()) {
x <- c("Quadrella steyermarkii (Standl.) Iltis & Cornejo",
  "Parus major Linnaeus, 1788", "Helianthus annuus var. texanus")
trys(gn_parse(x[1]))
trys(gn_parse(x[2]))
trys(gn_parse(x[3]))
trys(gn_parse(x))
# details
w <- trys(gn_parse(x, details = TRUE))
w[[1]]$details # details for one name
lapply(w, "[[", "details") # details for all names
z <- trys(gn_parse(x, details = FALSE)) # compared to regular
z
}
}
