% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rheroicon.R
\name{rheroicon}
\alias{rheroicon}
\title{An inline SVG icon from Heroicons}
\usage{
rheroicon(name = NULL, type = "outline", class = NULL)
}
\arguments{
\item{name}{string containing the name of an icon}

\item{type}{render icon by style; either 'solid', 'outline', or 'mini' (default: 'outline')}

\item{class}{a string containing one or more 'CSS' classes (optional)}
}
\value{
An string containing the 'SVG' markup of an icon
}
\description{
Render an icon by name. Run 'launch_gallery' to view all available icons
or search for icons using the 'find_icons' function.
}
\section{Styling Icons with 'CSS' class names}{


Icons are rendered from 'SVG' strings. All icons have three 'CSS' classes
defined: global, icon style, and icon name.

\describe{
\item{global}{All icons are returned with the 'CSS' class 'rheroicons'}
\item{icon style}{
All icons have a solid and an outlined version.
The icon style 'CSS' class is determined by the value entered for
'type'. Icons can have 'rheroicons-outline', 'rheroicons-solid', or
'rheroicons-mini'.
}
\item{icon name}{
The icon name is also passed into the list of 'CSS' class. These
are always structured in the following format: 'rheroicons-icon'.
If the icon is 'hand-thumb-down', the 'CSS' class would be
'rheroicons-hand-thumb-down'.
}
}

Use any of combination of these classes to style icons via 'CSS'.
In addition, you apply your own 'CSS' classes using the 'class' argument.
}

\examples{
rheroicon(name = "face-smile")
rheroicon(name = "face-smile", type = "solid")
rheroicon(name = "face-smile", class = "my-icon-set")

}
\references{
\url{https://heroicons.com}
\url{https://github.com/tailwindlabs/heroicons}
}
