% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrank.R
\name{rrankInd}
\alias{rrankInd}
\title{Return a matrix that highlights reverse rank orders of features of interest by column}
\usage{
rrankInd(matrix, ind, inValue = 1L, outValue = 0L, ...)
}
\arguments{
\item{matrix}{A matrix}

\item{ind}{An integer vector or a logical vector that gives the index}

\item{inValue}{Value to highlight the reverse ranks indexed by \code{ind}, 
see details below}

\item{outValue}{Values assigned to other values not indexed by \code{ind}}

\item{...}{Passed to \code{\link{rank}}}
}
\value{
A matrix of the same dimension and attributes of the input matrix,
     each column contains a vector of \code{inValue} and \code{outValue}. 
     Positions that match the reverse ranks of matrix values indexed by 
     \code{ind} are assigned the \code{inValue}, otherwise, 
     the \code{outValue}.
     
The function can be used to visualize the reverse ranks of
features of interest (rows of the input matrix) in each sample (columns of 
the input matrix). This is for instance useful for rank plots of features for
gene-set enrichment analysis.

Imagine that all features indexed by \code{ind} are the larger than 
all other features in each sample, then the returned matrix will have 
value \code{1} in the first rows (the number determined by the features 
indxed by \code{ind}), and \code{0} in the rest rows.
}
\description{
Return a matrix that highlights reverse rank orders of features of interest by column
}
\examples{
testMatrix <- matrix(c(3,6,4,5,2,4,8,3,2,5,4,7), ncol=3, byrow=FALSE)
print(testMatrix)
testInd <- c(2,4)
## verify that the command below returns 1 in positions occupied by 
## the reverse ranks of the values indexed by testInd
rrankInd(testMatrix, testInd)
testIndBool <- c(FALSE, TRUE, FALSE, TRUE)
rrankInd(testMatrix, testIndBool)
}
\seealso{
\code{\link{rank}}
}
