% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_ops.R
\name{r}
\alias{r}
\title{Raise tensor indices}
\usage{
r(x, ..., g = NULL)
}
\arguments{
\item{x}{A labeled tensor object, created by \code{\link{\%_\%}} or \code{\link[=tensor]{tensor()}}.}

\item{...}{Any number of index expressions. The indices need to occur
in \code{x}.}

\item{g}{A covariant metric tensor, a "metric_field" object. See \code{\link[=metric_field]{metric_field()}}
to create a new metric tensor, or use predefined metrics,
e.g. \code{\link[=g_eucl_cart]{g_eucl_cart()}}.
If no metric tensor is provided, indices are raised/lowered with
the identity matrix.}
}
\value{
A modified tensor object.
}
\description{
\code{r()} raises specified tensor indices using a covariant metric tensor
provided in \code{g}.
Note that the order of indices is not preserved due to performance reasons.
An error is thrown if the specified indices do not exist or are not in the
correct position.
}
\seealso{
Other tensor operations: 
\code{\link{Ops.tensor}()},
\code{\link{asym}()},
\code{\link{kron}()},
\code{\link{l}()},
\code{\link{subst}()},
\code{\link{sym}()}
}
\concept{index}
\concept{tensor operations}
