% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_pkg.R
\name{assess_pkg}
\alias{assess_pkg}
\title{Assess package}
\usage{
assess_pkg(pkg_source_path, rcmdcheck_args, covr_timeout = Inf)
}
\arguments{
\item{pkg_source_path}{- source path for install local}

\item{rcmdcheck_args}{- arguments for R Cmd check - these come from setup_rcmdcheck_args}

\item{covr_timeout}{- setting for covr time out}
}
\value{
list containing results - list containing metrics, covr, tm - trace matrix, and R CMD check
}
\description{
assess package for risk metrics
}
\examples{
\dontrun{
# set CRAN repo to enable running of reverse dependencies
r = getOption("repos")
r["CRAN"] = "http://cran.us.r-project.org"
old <- options(repos = r)

pkg_source_path <- system.file("test-data", "here-1.0.1.tar.gz", 
   package = "risk.assessr")
pkg_name <- sub("\\\\.tar\\\\.gz$", "", basename(pkg_source_path)) 
modified_tar_file <- modify_description_file(pkg_source_path)

# Set up the package using the temporary file
install_list <- set_up_pkg(modified_tar_file)

# Extract information from the installation list
build_vignettes <- install_list$build_vignettes
package_installed <- install_list$package_installed
pkg_source_path <- install_list$pkg_source_path
rcmdcheck_args <- install_list$rcmdcheck_args

# check if the package needs to be installed locally
package_installed <- install_package_local(pkg_source_path)

# Check if the package was installed successfully
if (package_installed == TRUE) {
  # Assess the package
  assess_package <- assess_pkg(pkg_source_path, rcmdcheck_args)
  # Output the assessment result
} else {
  message("Package installation failed.")
}
options(old)
}
}
