% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{is_prob}
\alias{is_prob}
\title{Verify that input is a probability (numeric value from 0 to 1).}
\usage{
is_prob(prob, NA_warn = FALSE)
}
\arguments{
\item{prob}{A numeric argument (scalar or vector) that is to be checked.}

\item{NA_warn}{Boolean value determining whether a warning is shown
for \code{NA} values.
Default: \code{NA_warn = FALSE}.}
}
\value{
A Boolean value:
\code{TRUE} if \code{prob} is a probability,
otherwise \code{FALSE}.
}
\description{
\code{is_prob} is a function that checks whether its argument \code{prob}
(a scalar or a vector) is a probability
(i.e., a numeric value in the range from 0 to 1).
}
\examples{
is_prob(1/2)                  # TRUE
is_prob(2)                    # FALSE

# vectors:
p_seq <- seq(0, 1, by = .1)   # Vector of probabilities
is_prob(p_seq)                # TRUE (as scalar, not: TRUE TRUE etc.)
is_prob(c(.1, 2, .9))         # FALSE (as scalar, not: TRUE FALSE etc.)

## watch out for:
# is_prob(NA)                   # => FALSE + NO warning!
# is_prob(0/0)                  # => FALSE + NO warning (NA + NaN values)
# is_prob(0/0, NA_warn = TRUE)  # => FALSE + warning (NA values)

## ways to fail:
# is_prob(8, NA_warn = TRUE)         # => FALSE + warning (outside range element)
# is_prob(c(.5, 8), NA_warn = TRUE)  # => FALSE + warning (outside range vector element)
# is_prob("Laplace", NA_warn = TRUE) # => FALSE + warning (non-numeric values)

}
\seealso{
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_valid_prob_set}} verifies the validity of probability inputs;
\code{\link{as_pc}} displays a probability as a percentage;
\code{\link{as_pb}} displays a percentage as probability.

Other verification functions: 
\code{\link{is_complement}()},
\code{\link{is_extreme_prob_set}()},
\code{\link{is_freq}()},
\code{\link{is_integer}()},
\code{\link{is_matrix}()},
\code{\link{is_perc}()},
\code{\link{is_suff_prob_set}()},
\code{\link{is_valid_prob_pair}()},
\code{\link{is_valid_prob_set}()},
\code{\link{is_valid_prob_triple}()}
}
\concept{verification functions}
