% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/italic_taxon_data.R
\name{italic_taxon_data}
\alias{italic_taxon_data}
\title{Get data of lichen taxa}
\usage{
italic_taxon_data(sp_names)
}
\arguments{
\item{sp_names}{A vector containing the scientific names of the lichen species.}
}
\value{
A dataframe containing the taxonomy, ecology distribution and rarity of the lichen species passed as input.
}
\description{
This function returns a dataframe containing taxonomy, ecology_traits, regions_distribution, ecoregions_distribution of the lichen species passed as input. For more info about these parameters see https://italic.units.it/?procedure=base&t=59&c=60#otherdata
Only accepts names that exist in the database of ITALIC.
}
\note{
Before using this function with a list of names, first obtain their accepted names
using \code{italic_match()}.
Example workflow:
\preformatted{
      names_matched <- italic_match(your_names)
      italic_taxon_data(names_matched$accepted_name)
      }
}
\examples{
\dontrun{
italic_taxon_data(c("Cetraria ericetorum Opiz", "Lecanora salicicola H. Magn."))
}

}
\references{
ITALIC - The Information System on Italian Lichens: data about taxa
\url{https://italic.units.it/?procedure=base&t=59&c=60#otherdata}
}
