% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/providers.R
\name{.obs_gathering}
\alias{.obs_gathering}
\title{Generates the Java object for automatic aggregation of the data}
\usage{
.obs_gathering(
  period = 0,
  aggregationType = NULL,
  allowPartialAggregation = FALSE,
  cleanMissing = TRUE
)
}
\arguments{
\item{period}{The annual frequency of the series. If 0, the frequency.}

\item{aggregationType}{The type of the aggregation to be applied on the series (only used if "period" is different from 0).}

\item{allowPartialAggregation}{Specifies if  the aggregation is performed or not when they are missing periods.}

\item{cleanMissing}{Specifies if missing values at the beginning and at the end of the data are removed from the series.}
}
\value{
An internal Java object.
}
\description{
Generates the Java object for automatic aggregation of the data
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}

.obs_gathering(period=4, aggregationType="Sum")
\dontshow{\}) # examplesIf}
}
