% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jqpd.R
\name{jqpd}
\alias{jqpd}
\title{Calculates the parameters of the Johnson Quantile-Parameterised Distribution}
\usage{
jqpd(x, lower = 0, upper = Inf, alpha = 0.1)
}
\arguments{
\item{x}{a length 3 numeric vector containing the symmetric percentile
triplet values used to parameterise the distribution.}

\item{lower}{a real number specifying the lower bound of the distribution.
(default: 0)}

\item{upper}{a real number specifying the upper bound of the distribution. A
value of Inf indicates a semi-bounded distribution. (default: Inf)}

\item{alpha}{a real number (between 0 and 0.5) used to describe the symmetric
percentile triplet for which the quantile values provided in 'x' correspond.
For instance, alpha = 0.1 (default value) indicates the percentiles used are
[0.1, 0.5, 0.9].}
}
\value{
A \code{jqpd} object with elements
\item{x}{a length 3 numeric vector containing the symmetric percentile
 triplet values used to parameterise the distribution}
\item{alpha}{a real number (between 0 and 0.5) used to describe the symmetric
 percentile triplet for which the quantile values provided in 'x' correspond}
\item{lower}{a real number specifying the lower bound of the distribution}
\item{upper}{a real number specifying the upper bound of the distribution}
\item{c}{distribution parameter}
\item{n}{distribution parameter}
\item{eta}{distribution parameter}
\item{delta}{distribution parameter}
\item{lambda}{distribution parameter}
\item{k}{distribution parameter}
}
\description{
Calculates the parameters of the Johnson Quantile-Parameterised Distribution
}
\examples{
theta <- jqpd(c(0.32, 0.40, 0.6), 0, 1, alpha = 0.1)
}
