% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance_matrix.R
\name{U_gh}
\alias{U_gh}
\title{alpha-norm of u*g + v*h.}
\usage{
U_gh(g, h, u, v, ...)
}
\arguments{
\item{g, h}{functions \eqn{g,h: \R \to \R} with finite alpha-norm (see \code{\link{Norm_alpha}}).}

\item{v, u}{real numbers}

\item{...}{additional parameters to pass to Norm_alpha}
}
\description{
alpha-norm of u*g + v*h.
}
\examples{
g<-function(x) exp(-x^2)
h<-function(x) exp(-abs(x))
U_gh(g=g, h=h, u=4, v=3, alpha=1.7)
}
