% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorGSEA.R
\name{plot.factorGSEA}
\alias{plot.factorGSEA}
\title{GSEA plot for specific gene set and factor using factorGSEA results}
\usage{
\method{plot}{factorGSEA}(
  x,
  y,
  geneSetName,
  useFactor,
  xTitleSize = 10,
  xTextSize = 8,
  yTitleSize = 10,
  yTextSize = 8,
  titleSize = 12,
  captionTextSize = 8,
  ESLineColor = "green",
  ESLinewidth = 1,
  hitsLineColor = "black",
  hitsLinewidth = 0.5,
  loadingBarColor = "grey",
  ...
)
}
\arguments{
\item{x}{A \code{factorGSEA} object.}

\item{y}{Not used, for S3 method convention.}

\item{geneSetName}{A character string for the gene set name to plot.}

\item{useFactor}{A character string (e.g. 'Factor_1') or just numeric index
for the factor name to plot.}

\item{xTitleSize, yTitleSize}{Numeric, size for x or y axis titles,
respectively. Default \code{10}.}

\item{xTextSize, yTextSize}{Numeric, size for x or y axis text,
respectively. Default \code{8}.}

\item{titleSize}{Numeric, size for the main plot title. Default \code{12}.}

\item{captionTextSize}{Numeric, size for the caption text. Default \code{8}.}

\item{ESLineColor}{Color for the enrichment score line. Default
\code{'green'}.}

\item{ESLinewidth}{Numeric, line width for the enrichment score line.
Default \code{1}.}

\item{hitsLineColor}{Color for the hits line. Default \code{'black'}.}

\item{hitsLinewidth}{Numeric, line width for the hits line. Default
\code{0.5}.}

\item{loadingBarColor}{Color for the loading bar. Default \code{'grey'}.}

\item{...}{Not used.}
}
\value{
ggplot object
}
\description{
GSEA plot for specific gene set and factor using factorGSEA results
}
