% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_grain_sizes.R
\name{def_grain_sizes}
\alias{def_grain_sizes}
\title{Define grain sizes}
\usage{
def_grain_sizes(
  grain_name = NULL,
  grain_group = NULL,
  soil_group = NULL,
  grain_id = NULL,
  grain_symbol = NULL,
  grain_classification = NULL
)
}
\arguments{
\item{grain_name}{\code{character}. The name of the specific grain (e.g.,
"Coarse Gravel") to return a definition for.}

\item{grain_group}{\code{character}. The name of the group the grain
belongs to (e.g., "Gravel") to return a definition for.}

\item{soil_group}{\code{character}. The name of the family of soils the
grain belongs to (e.g., "Coarse Soil") to return a definition for.}

\item{grain_id}{\code{integer}. The unique identification number(s) of the
desired grain definitions(s) to return a definition for.}

\item{grain_symbol}{\code{character}. The abbreviation of the desired grain
definition(s) (e.g., "CGr") to return a definition for.}

\item{grain_classification}{\code{character}. The classification scheme the
given grain belongs to (e.g., "Wentworth") to return a definition for.}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{grain_id}: The unique identification number of the
grain.
\item \code{grain_symbol}: The grain symbol (or abbreviation) to use for
display purposes.
\item \code{grain_name}: The name of the grain.
\item \code{grain_group}: The name of the group the grain belongs to.
\item \code{soil_group}: The name of the soil family the grain belongs
to.
\item \code{min_size}: The minimum size of the size in millimeters.
\item \code{max_size}: The maximum size of the grain in millimeters.
\item \code{classification}: The classification scheme the given grain
belongs to.
}
}
\description{
A function to return grain size definitions from the
Macrostrat Database based on user-specified arguments. If no arguments
are specified, all definitions are returned.
}
\section{Developer(s)}{

Lewis A. Jones
}

\section{Reviewer(s)}{

William Gearty
}

\examples{
\donttest{
 # Return all definitions
 ex1 <- def_grain_sizes()
 # Return grain sizes by group
 ex2 <- def_grain_sizes(grain_group = "Gravel")
}
}
\seealso{
Geologic features and attributes:
\code{\link{def_econs}()},
\code{\link{def_environments}()},
\code{\link{def_lithologies}()},
\code{\link{def_lithology_att}()},
\code{\link{def_measurements}()},
\code{\link{def_minerals}()},
\code{\link{def_structures}()}
}
\concept{defs_feat}
