% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eodp.R
\name{get_eodp}
\alias{get_eodp}
\title{Retrieve core data from ocean drilling programs}
\usage{
get_eodp(column_id = NULL, site = NULL, leg = NULL, program = NULL, sf = FALSE)
}
\arguments{
\item{column_id}{\code{integer}. Filter cores by their unique identification
number(s).}

\item{site}{\code{character}. Filter cores to those from a particular
drilling site (e.g., "U1351").}

\item{leg}{\code{character}. Filter cores to those from a particular drilling
leg or expedition (e.g., "317").}

\item{program}{\code{character}. Filter cores to those from a particular
drilling program ("DSDP", "IODP", or "ODP").}

\item{sf}{\code{logical}. Should the results be returned as an \code{sf} object?
Defaults to \code{FALSE}.}
}
\value{
A \code{data.frame} containing, for each retrieved core:
\itemize{
\item \code{col_group}: The name of the drilling program and
leg/expedition.
\item \code{site_hole}: The name of the drilling site and hole.
\item \code{date_started}: The date on which drilling commenced.
\item \code{ref_id}: The unique identifier of the reference.
\item \code{col_id}: The unique identifier of the Macrostrat column.
\item \code{lat}: Decimal degree latitude of the core.
\item \code{lng}: Decimal degree longitude of the core.
\item \code{top_depth}: A vector describing the height of the top of each
unit.
\item \code{bottom_depth}: A vector describing the height of the bottom of
each unit.
\item \code{primary_lith}: A vector giving the name of the primary
lithology of each unit.
\item \code{lith_id}: A vector giving the unique identifier of the primary
lithology of each unit.
\item \code{minor_lith}: A vector giving the name of the primary lithology
of each unit.
}
If \code{sf} is \code{TRUE}, an \code{sf} object is returned instead, with a "geometry"
column that contains the spatial data instead of the \code{lat}/\code{lng} columns.
}
\description{
A function to retrieve data from the
\href{https://eodp.github.io}{Extending Ocean Drilling Pursuits (eODP)}
project, a collation of sedimentary description data
from ocean drilling cores. This currently includes cores from the Deep Sea
Drilling Project (DSDP), Integrated Ocean Drilling Program (IODP), and Ocean
Drilling Program (ODP). Note: eODP data is currently being integrated
into Macrostrat's data entities (e.g. columns and units) and should be
available via \code{\link[=get_columns]{get_columns()}} and \code{\link[=get_units]{get_units()}} in the future.
}
\details{
More information can be found about the inputs for this function by
using \code{\link[=def_drilling_sites]{def_drilling_sites()}}.
}
\section{Developer(s)}{

Bethany Allen
}

\section{Reviewer(s)}{

William Gearty
}

\section{References}{

Sessa JA, Fraass AJ, LeVay LJ, Jamson KM, and Peters SE. (2023). The
Extending Ocean Drilling Pursuits (eODP) Project: Synthesizing Scientific
Ocean Drilling Data. Geochemistry, Geophysics, Geosystems, 24 (3)
e2022GC010655. \doi{10.1029/2022GC010655}.
}

\examples{
\donttest{
# Get data for specific cores
cores <- get_eodp(column_id = c(5081, 5082))
# Get data for all cores at a specific site
cores <- get_eodp(site = "U1351")
# Get data for all cores for a specific leg
cores <- get_eodp(leg = "317")
# Get data for all cores for a specific program
cores <- get_eodp(program = "IODP")
}
}
\seealso{
External data:
\code{\link{def_drilling_sites}()},
\code{\link{def_measurements}()},
\code{\link{get_fossils}()},
\code{\link{get_measurements}()}
}
\concept{external}
