% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_walk.R
\name{sample_random_walk}
\alias{sample_random_walk}
\title{Sample new state from random walk proposal.}
\usage{
sample_random_walk(
  state,
  target_distribution,
  scale_and_shape,
  sample_auxiliary = stats::rnorm
)
}
\arguments{
\item{sample_auxiliary}{Function which generates a random vector from
auxiliary variable distribution.}
}
\value{
Proposal object. A list with entries
\itemize{
\item \code{sample}: a function to generate sample from proposal distribution given
current chain state,
\item \code{log_density_ratio}: a  function to compute log density ratio for proposal
for a given pair of current and proposed chain states,
\item \code{update}: a function to update parameters of proposal,
\item \code{parameters}: a function to return list of current parameter values.
\item \code{default_target_accept_prob}: a function returning the default target
acceptance rate to use for any scale adaptation.
\item \code{default_initial_scale}: a function which given a dimension gives a default
value to use for the initial proposal scale parameter.
}
}
\description{
Sample new state from random walk proposal.
}
\keyword{internal}
