% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{nassqs_auth}
\alias{nassqs_auth}
\title{Get/Set the environmental variable NASSQS_TOKEN to the API key}
\usage{
nassqs_auth(key)
}
\arguments{
\item{key}{the API key (obtained from \url{https://quickstats.nass.usda.gov/api/})}
}
\description{
If the API key is provided, sets the environmental variable. You can set
your API key in four ways:
}
\details{
\enumerate{
\item directly or as a variable from your \code{R}
program: \verb{nassqs_auth(key = "<your api key>"}
\item by setting \code{NASSQS_TOKEN} in your \code{R} environment file (you'll never have
to enter it again).
\item by entering it into the console when asked (it will be stored for the
rest of the session.)
}
}
\examples{
# Set the API key
nassqs_auth(key = "<your api key>")
Sys.getenv("NASSQS_TOKEN")
}
