% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_docx.R
\name{export_docx}
\alias{export_docx}
\alias{export_docx.flextable}
\alias{export_docx.default}
\title{Export a flextable of results from (robust) mediation analysis to 'Microsoft
Word'}
\usage{
export_docx(object, file, ...)

\method{export_docx}{flextable}(object, file, size = c("A4", "letter"), ...)

\method{export_docx}{default}(object, file, ...)
}
\arguments{
\item{object}{an object of class \code{"\link[flextable]{flextable}"}, or
an object containing results from (robust) mediation analysis that can be
converted to the subclass \code{"mediation_flextable"} via
\code{\link{to_flextable}()}.}

\item{file}{a character string specifying the path an file name for the
\proglang{Microsoft Word} file to be generated.}

\item{\dots}{for the \code{"flextable"} method, additional arguments to
be passed down to \code{\link[officer]{prop_section}()} for defining page
composition such as page size, page orientation, and margins.  For the
default method, additional arguments to be passed down to
\code{\link{to_flextable}()} for converting results from (robust)
mediation analysis.}

\item{size}{a character string specifying the page size.  Possible values
are \code{"A4"} for A4 format (297 x 210 mm) or \code{"letter"} for US
letter format (11 x 8.5 inches).}
}
\value{
The function is called for its side effect of creating a \proglang{Microsoft
Word} file.  It returns the path to the file invisibly.
}
\description{
Export a \code{\link[flextable]{flextable}} object to \proglang{Microsoft
Word}. This function is intended for tables of results from (robust)
mediation analysis.  It is essentially a wrapper for
\code{\link[flextable]{save_as_docx}()} with a more convenient argument
for page size, and it uses additional information from subclass
\code{"\link[=to_flextable]{mediation_flextable}"} to determine the page
orientation.
}
\examples{
data("BSG2014")

# perform mediation analysis via robust bootstrap test ROBMED
set.seed(20241101)
boot <- test_mediation(BSG2014,
                       x = "SharedLeadership",
                       y = "TeamPerformance",
                       m = c("ProceduralJustice",
                             "InteractionalJustice"),
                       covariates = c("AgeDiversity",
                                      "GenderDiversity"))

# construct flextable of results
ft <- to_flextable(boot)

# export to Microsoft Word
file_name <- tempfile(fileext = ".docx")
export_docx(ft, file = file_name)

}
\seealso{
\code{\link{export_pptx}()}

\code{\link[flextable]{flextable}()}, \code{\link{to_flextable}()}
}
\author{
Andreas Alfons
}
