% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleEstimators.R
\name{rob_scale}
\alias{rob_scale}
\title{Robust scale estimators based on median absolute deviation}
\usage{
rob_scale(
  x,
  y,
  type = c("S1", "S2", "S3", "S4"),
  na.rm = FALSE,
  check.for.zero = FALSE
)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{a (non-empty) numeric vector of data values.}

\item{type}{character that specifies the estimator for the variance, can be
\code{"S1"}, \code{"S2"}, \code{"S3"} and \code{"S4"};
see details for description of the scale estimators.}

\item{na.rm}{a logical value indicating whether NA values in \code{x} and
\code{y} should be stripped before the computation proceeds. The
default is \code{na.rm = FALSE}.}

\item{check.for.zero}{logical value indicating a warning should be triggered
if the scale estimate is zero. The default is
\code{FALSE}.}
}
\value{
An estimate of the pooled variance of the two samples.
}
\description{
\code{rob_scale} calculates an estimator for the within-sample dispersion
based on two samples.
}
\details{
For definitions of the scale estimators, see Fried and Dehling (2011).

If \code{check.for.zero = TRUE}, an error is thrown when the scale estimate
is zero. This argument is only included because the function is used in
\code{\link{rob_perm_statistic}} to compute values of robust test statistics
where the scale estimate is used for standardization. A scale estimate of zero
leads to a non-existing test statistic, so that the corresponding test cannot
be performed.
}
\references{
\insertRef{FriDeh11robu}{robnptests}
}
