% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robregcc.R
\name{cpsc_sp}
\alias{cpsc_sp}
\title{Principal sensitivity component analysis with compositional covariates in sparse setting.}
\usage{
cpsc_sp(
  X0,
  y0,
  alp = 0.4,
  cfac = 2,
  b1 = 0.25,
  cc1 = 2.937,
  C = NULL,
  we,
  type,
  control = list()
)
}
\arguments{
\item{X0}{CLR transformed predictor matrix.}

\item{y0}{model response vector}

\item{alp}{(0,0.5) fraction of data sample to be removed to generate subsample}

\item{cfac}{initial value of shift parameter for weight construction/initialization}

\item{b1}{tukey bisquare function parameter producing desired breakdown point}

\item{cc1}{tukey bisquare function parameter producing desired breakdown point}

\item{C}{sub-compositional matrix}

\item{we}{penalization index for model parameters beta}

\item{type}{1/2 for l1 / l2 loss in the model}

\item{control}{a list of internal parameters controlling the model fitting}
}
\value{
\item{betaf}{TModel parameter estimate}
  \item{residuals}{residual estimate}
}
\description{
Produce model and its residual estimate based on PCS analysis.
}
\examples{
 

library(robregcc)
library(magrittr)

data(simulate_robregcc)
X <- simulate_robregcc$X;
y <- simulate_robregcc$y
C <- simulate_robregcc$C
n <- nrow(X); p <- ncol(X); k <-  nrow(C)

Xt <- cbind(1,X)  # include intercept in predictor
C <- cbind(0,C)    # include intercept in constraint
bw <- c(0,rep(1,p)) # weights not penalize intercept 

example_seed <- 2*p+1               
set.seed(example_seed) 

# Breakdown point for tukey Bisquare loss function 
b1 = 0.5                    # 50\% breakdown point
cc1 =  1.567                # corresponding model parameter
b1 = 0.25; cc1 =  2.937   

# Initialization [PSC analysis for compositional data]
control <- robregcc_option(maxiter = 1000,
 tol = 1e-4,lminfac = 1e-7)
fit.init <- cpsc_sp(Xt, y,alp = 0.4, cfac = 2, b1 = b1,
cc1 = cc1,C,bw,1,control) 

}
\references{
Mishra, A., Mueller, C.,(2019) \emph{Robust regression with compositional covariates. In prepration}. arXiv:1909.04990.
}
