\name{coef.rsfa}
\alias{coef.rsfa}
\title{Coefficients Method for Class \code{rsfa}}
\usage{
\method{coef}{rsfa}(object, ...)
}
\arguments{
  \item{object}{An object of class \code{rsfa}.}

  \item{...}{Unused.}
}
\value{
  A named vector of MDPD estimates.
}
\description{
  This function extracts the estimates from the object of class \code{rsfa}.
}
\examples{
## Example using the 'riceProdPhil' dataset from the `frontier` package
library(frontier)
data(riceProdPhil)

my.model <- log(PROD) ~ log(AREA) + log(LABOR) + log(NPK) + log(OTHER)
fit.ml <- rsfa(my.model, data = riceProdPhil)
coef(fit.ml)
fit.mdpde<- rsfa(my.model, data = riceProdPhil, alpha = 0.1)
coef(fit.mdpde)
}
