% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustSFM.R
\name{print.rsfa}
\alias{print.rsfa}
\title{Print Method for Class \code{rsfa}}
\usage{
\method{print}{rsfa}(x, ...)
}
\arguments{
  \item{x}{An object of class \code{rsfa}.}

  \item{...}{Unused.}
}
\value{
  A named vector of MDPD estimates.
}
\description{
  This function prints the results of the \code{rsfa} estimation.
}
\examples{
## Example using the 'riceProdPhil' dataset from the `frontier` package
library(frontier)
data(riceProdPhil)

my.model <- log(PROD) ~ log(AREA) + log(LABOR) + log(NPK) + log(OTHER)
fit.ml <- rsfa(my.model, data = riceProdPhil)
print(fit.ml)
fit.mdpde<- rsfa(my.model, data = riceProdPhil, alpha = 0.1)
print(fit.mdpde)
}
