% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ROCKproject_config.R
\name{make_ROCKproject_config}
\alias{make_ROCKproject_config}
\title{Make a ROCK project configuration file}
\usage{
make_ROCKproject_config(
  project = list(title = "Default title", authors = "Authors", authorIds = NULL, version
    = "1.0", ROCK_version = "1.0", ROCK_project_version = "1.0", date_created =
    format(Sys.time(), "\%Y-\%m-\%d \%H:\%M:\%S \%Z"), date_modified = format(Sys.time(),
    "\%Y-\%m-\%d \%H:\%M:\%S \%Z")),
  codebook = list(urcid = "", embedded = NULL, local = ""),
  sources = list(extension = ".rock", regex = NULL, dirsToIncludeRegex = "data/",
    recursive = TRUE, dirsToExcludeRegex = NULL, filesToIncludeRegex = NULL,
    filesToExcludeRegex = NULL),
  workflow = list(pipeline = NULL, actions = NULL),
  extra = NULL,
  path = NULL
)
}
\arguments{
\item{project}{A named list with the project metadata.}

\item{codebook}{A named list with the project's codebook.}

\item{sources}{A named list with the project's source import settings.}

\item{workflow}{A named list with the project's workflow settings.}

\item{extra}{A named list with any additional things you want to store in the
project's configuration file. One never knows whether being able to do that
comes in handy at some point.}

\item{path}{If not \code{NULL}, the ROCK project configuration will be written to
the file \verb{_ROCKproject.yml} in this directory.}
}
\value{
A list with the passed configuration in a list called
\verb{$input}, and as YAML in a character vector called \verb{$yaml}.
}
\description{
This function creates a ROCK project configuration file in the YAML
format. See the Details section for more information.
}
\details{
For more information about the ROCK project configuration file format,
see the \code{ROCKproject-format} vignette. You can view this from R using:

\code{vignette("ROCKproject-format", package="rock");}

You can also visit it at \url{https://rock.opens.science/articles/ROCKproject-format.html}.
}
\examples{
### To get the default configuration,
### just pass no arguments:
defaultConfig <-
  rock::make_ROCKproject_config();

### You can then extract the object with settings
config <- defaultConfig$input;

### Edit some of them
config$project$title <- "Some new title";

### Call the function again with the new arguments
myConfig <-
  rock::make_ROCKproject_config(
    project = config$project,
    codebook = config$codebook,
    sources = config$sources,
    workflow = config$workflow,
    extra = config$extra
  );

### View the result
cat(myConfig$yaml);

}
