% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-json.R
\name{read_rocrate}
\alias{read_rocrate}
\title{Wrapper for \link[jsonlite:read_json]{jsonlite::read_json}}
\usage{
read_rocrate(path, simplifyVector = FALSE, ...)
}
\arguments{
\item{path}{file on disk}

\item{simplifyVector}{simplifies nested lists into vectors and data frames. See \code{\link[jsonlite:fromJSON]{fromJSON()}}.}

\item{...}{
  Arguments passed on to \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON}}
  \describe{
    \item{\code{txt}}{a JSON string, URL or file}
    \item{\code{simplifyDataFrame}}{coerce JSON arrays containing only records (JSON objects) into a data frame}
    \item{\code{simplifyMatrix}}{coerce JSON arrays containing vectors of equal mode and dimension into matrix or array}
    \item{\code{flatten}}{automatically \code{\link[jsonlite:flatten]{flatten()}} nested data frames into a single non-nested data frame}
  }}
}
\value{
Invisibly the RO-Crate stored in \code{path}.
}
\description{
Wrapper for \link[jsonlite:read_json]{jsonlite::read_json}. Enforces that the object read is an
RO-Crate.
}
