% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_simulation.R
\name{add_poisson_outcome}
\alias{add_poisson_outcome}
\title{Create a Poisson outcome from linear predictors}
\usage{
add_poisson_outcome(
  data,
  linear_col = "y_linear",
  rate_col = "y_rate",
  count_col = "y_count"
)
}
\arguments{
\item{data}{A data frame containing effect columns prefixed with \code{"."}.}

\item{linear_col}{Name of the column to store the summed linear predictor (default \code{"y_linear"}).}

\item{rate_col}{Name of the column to store Poisson rates (default \code{"y_rate"}).}

\item{count_col}{Name of the column to store Poisson counts (default \code{"y_count"}).}
}
\value{
A \code{tibble} with added linear predictor, rate, and count columns.
}
\description{
Generates a Poisson-distributed count outcome by summing effects, exponentiating to obtain rates, and drawing counts.
}
\examples{
df <- tibble::tibble(.beta = 0.5, .u = rnorm(5), .error = rnorm(5))
add_poisson_outcome(df)
}
