% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_spread.R
\name{box.spread}
\alias{box.spread}
\title{Box Spread Strategy Function}
\usage{
box.spread(
  k_long_call,
  k_short_call,
  k_long_put,
  k_short_put,
  c1,
  c2,
  p1,
  p2,
  llimit = 20,
  ulimit = 20
)
}
\arguments{
\item{k_long_call}{Excercise Price of Long call Option}

\item{k_short_call}{Excercise Price of Short call Option}

\item{k_long_put}{Excercise Price of Long Put Optioon}

\item{k_short_put}{Excercise Price of Short Put Option}

\item{c1}{Premium of Long Call Option}

\item{c2}{Premium of Short Call Option}

\item{p1}{Premium of Long Put Option}

\item{p2}{Premium of Short Put Option}

\item{llimit}{Lower limit of stock price at Expiration., Default: 20}

\item{ulimit}{Upper Limit of Stock Price at Expiration, Default: 20}
}
\value{
Returns the profit/loss generated from the strategy along with the profit/loss of individual contract and an interactive graph for the same.
}
\description{
This function can be used to develop a box spread strategy for options. A box spread is an options arbitrage strategy that combines buying a bull call spread with a matching bear put spread
}
\details{
To construct a box spread, a trader buys an in-the-money (ITM) call, sells an out-of-the-money (OTM) call, buys an ITM put and sells an OTM put. In other words, buy an ITM call and put and then sell an OTM call and put.
}
\examples{
box.spread(100, 105, 95, 110, 3.2, 2.6, 1.1, 2.4)
}
