% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/put_minorgreek.R
\name{put.minorgreek}
\alias{put.minorgreek}
\title{Specified Minor Option Greek}
\usage{
put.minorgreek(minorgreek = c("lambda", "vomma"), s, k, t, sd, r, d = 0)
}
\arguments{
\item{minorgreek}{Character String of the minor greek to be calculated}

\item{s}{Spot Price of Underlying Asset}

\item{k}{Exercise Price of Contract}

\item{t}{Time to Expiration}

\item{sd}{Volatality}

\item{r}{Risk free rate of return}

\item{d}{Divident Yield (use cont.rate()), Default: 0}
}
\value{
Output gives the Specified Minor Greek of a Option Contract.
}
\description{
Calculate the Specified Minor Option Greek of a Contract
}
\details{
Vomma is the rate at which the vega of an option will react to volatility in the market. In options trading, Lamba is the Greek letter assigned to variable which tells the ratio of how much leverage an option is providing as the price of that option changes.
}
\examples{
put.minorgreek('lambda', 100, 105, 0.25, 0.35, 0.0488)
}
