% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unweighted_estimators.R
\name{unweighted_gplm}
\alias{unweighted_gplm}
\title{Unweighted (baseline) estimator for the generalised partially linear model}
\usage{
unweighted_gplm(
  y_on_xz_formula,
  y_on_xz_learner,
  y_on_xz_pars = list(),
  Gy_on_z_formula,
  Gy_on_z_learner,
  Gy_on_z_pars = list(),
  x_formula,
  x_learner,
  x_pars = list(),
  link = "identity",
  data,
  K = 5,
  S = 1
)
}
\arguments{
\item{y_on_xz_formula}{a two-sided formula object describing the regression model for \eqn{\mathbb{E}[Y|X,Z]} (regressing \eqn{Y} on \eqn{(X,Z)}).}

\item{y_on_xz_learner}{a string specifying the regression method to fit the regression as given by \code{y_on_xz_formula} (e.g. \code{randomforest, xgboost, neuralnet, gam}).}

\item{y_on_xz_pars}{a list containing hyperparameters for the \code{y_on_xz_learner} chosen. Default is an empty list, which performs hyperparameter tuning.}

\item{Gy_on_z_formula}{a two-sided formula object describing the regression model for \eqn{\mathbb{E}[g(\mathbb{E}[Y|X,Z])|Z]} (regressing \eqn{g(\hat{E}[Y|X,Z])} on \eqn{Z}).}

\item{Gy_on_z_learner}{a string specifying the regression method to fit the regression as given by \code{Gy_on_z_formula} (e.g. \code{randomforest, xgboost, neuralnet, gam}).}

\item{Gy_on_z_pars}{a list containing hyperparameters for the \code{Gy_on_z_learner} chosen. Default is an empty list, which performs hyperparameter tuning.}

\item{x_formula}{a two-sided formula object describing the regression model for \eqn{\mathbb{E}[X|Z]}.}

\item{x_learner}{a string specifying the regression method to fit the regression of \eqn{X} on \eqn{Z} as given by \code{x_formula} (e.g. \code{randomforest, xgboost, neuralnet, gam}).}

\item{x_pars}{a list containing hyperparameters for the \code{x_learner} chosen. Default is an empty list, which performs hyperparameter tuning.}

\item{link}{link function (\eqn{g}). Options include \code{identity}, \code{log}, \code{sqrt}, \code{logit}, \code{probit}. Default is \code{identity}.}

\item{data}{a data frame containing the variables for the partially linear model.}

\item{K}{the number of folds used for \eqn{K}-fold cross-fitting. Default is 5.}

\item{S}{the number of repeats to mitigate the randomness in the estimator on the sample splits used for \eqn{K}-fold cross-fitting. Default is 5.}
}
\value{
A list containing:
  \describe{
    \item{\code{theta}}{The estimator of \eqn{\theta_0}.}
    \item{\code{stderror}}{Huber robust estimate of the standard error of the \eqn{\theta_0}-estimator.}
    \item{\code{coefficients}}{Table of \eqn{\theta_0} coefficient estimator, standard error, z-value and p-value.}
  }
}
\description{
Estimates the parameter of interest \eqn{\theta_0} in the generalised partially linear regression model
\deqn{g(\mathbb{E}[Y|X,Z]) = X\theta_0 + f_0(Z),} as in \code{roseRF_gplm} but without
any weights i.e. \eqn{J=1}, \eqn{M_1(X)=X} and \eqn{w_1\equiv 1}.
}
