% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_content.R
\name{show_content}
\alias{show_content}
\title{Show the content of an OSM file}
\usage{
show_content(
  input_path,
  output_format = c("html", "opl", "xml"),
  object_type = c("all", "node", "way", "relation", "changeset"),
  echo_cmd = FALSE,
  spinner = TRUE,
  preview = TRUE
)
}
\arguments{
\item{input_path}{A string. The path to the OSM file whose content should be
shown. Please see \link{file_formats} for a list of supported file formats.}

\item{output_format}{A string. The format in which the content should be
shown. Either \code{"html"}, \code{"opl"} or \code{"xml"}. Please note that the \code{"html"}
option, although the most human readable format, results in large files
that may be very slow to open and inspect, depending on the size of the
input file.}

\item{object_type}{A character vector. The object types that should be
included in the output. Please note that using \code{"all"} is a simple way of
passing all other available types (\code{"node"}, \code{"way"}, \code{"relation"} and
\code{"changeset"}).}

\item{echo_cmd}{A logical. Whether to print the Osmium command generated by
the function call to the screen. Defaults to \code{FALSE}.}

\item{spinner}{A logical. Whether to show a reassuring spinner while the
Osmium call is being executed. Defaults to \code{TRUE}.}

\item{preview}{A logical. Whether to open the temporary file in which the
content of the OSM file was saved.}
}
\value{
The path to the temporary file in which the OSM file content was
saved.
}
\description{
Displays the content of an OSM file either in \code{.html}, \code{.xml} or \code{.opl}
format.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pbf_path <- system.file("extdata/cur.osm.pbf", package = "rosmium")

small_pbf <- tags_filter(
  pbf_path,
  "note",
  tempfile(fileext = "osm.pbf"),
  omit_referenced = TRUE
)

# both function calls below result in outputs with the same object types

show_content(small_pbf, object_type = "all")
show_content(
  small_pbf,
  object_type = c("node", "way", "relation", "changeset")
)

# only show nodes and ways

show_content(small_pbf, object_type = c("node", "way"))

# display all objects in xml format

show_content(small_pbf, output_format = "xml")
\dontshow{\}) # examplesIf}
}
