% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{markdownify}
\alias{markdownify}
\title{Convert text to Markdown}
\usage{
markdownify(text, scope = c("full", "simple", "unlink", "indent", "none"))
}
\arguments{
\item{text}{A character vector containing \code{.Rd} style annotations.}

\item{scope}{The scope of transformations: \code{"simple"} runs only transformations
that shouldn't substantially change the resulting \code{.Rd} files, \code{"full"} runs
all transformations. In larger packages, run \code{"none"}, double-check and track
the changes, and then run \code{"simple"} and then \code{"full"}.}
}
\value{
The same vector with \code{.Rd} style annotations converted to Markdown
style annotations.
}
\description{
Converts a character vector from Rd to Markdown.

The \code{scope} argument controls the depth of the transformation.

With \code{scope = "none"}, no transformations are carried out.
The only effect is that Markdown is enabled for this package.

With \code{scope = "simple"}, the following elements are converted:
\itemize{
\item \verb{\\\code{}}
\item \verb{\\\\emph\{\}}
\item \verb{\\\\bold\{\}} and \verb{\\\\strong\{\}}
\item \verb{\\\\href\{\}}
\item \verb{\\\url{}}
}

With \code{scope = "full"}, the following elements are converted in addition:

\itemize{
\item \verb{\\\code{\\link{}}} and \verb{\\\link{}}, with \verb{[]} options
\item \verb{\\\linkS4class{}}
}

With \code{scope = "unlink"}, \emph{only} the following elements are translated:
\itemize{
\item \verb{\\\link{...}} to \code{...}
}

With \code{scope = "indent"}, \verb{@param} and \verb{@return} tags spanning multiple lines
are indented with two spaces.
}
\examples{
text <- c(
  "Both \\\\emph{italics} and \\\\bold{bold} text.",
  paste0("We can also convert code: \\\\", "code{\\\\", "link{identity}}.")
)

text
markdownify(text)

}
