% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_forecast}
\alias{is_forecast}
\title{Check forecast}
\usage{
is_forecast(x)
}
\arguments{
\item{x}{Input object to be checked}
}
\value{
Logical as to whether or not the input object inherits the "signal" and "forecast" classes.
}
\description{
This function checks if the object is of class \code{signal} and \code{forecast}.
}
\examples{

## get path to example forecast file
fp <- system.file("extdata/forecast/2022-10-31-SigSci-TSENS.csv", package = "rplanes")
ex_forecast <- read_forecast(fp)
sig <- to_signal(ex_forecast, outcome="flu.admits", type="forecast", horizon=4, resolution="weeks")
is_forecast(sig)
}
