% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_observed}
\alias{is_observed}
\title{Check observed}
\usage{
is_observed(x)
}
\arguments{
\item{x}{Input object to be checked}
}
\value{
Logical as to whether or not the input object inherits the "signal" and "observed" classes.
}
\description{
This function checks if the object is of class \code{signal} and \code{observed}.
}
\examples{
hosp <- read.csv(system.file("extdata/observed/hdgov_hosp_weekly.csv", package = "rplanes"))
hosp$date <- as.Date(hosp$date, format = "\%Y-\%m-\%d")
sig <- to_signal(hosp, outcome = "flu.admits", type = "observed", resolution = "weeks")
is_observed(sig)
}
