% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct.R
\name{to_signal}
\alias{to_signal}
\title{Create signal object}
\usage{
to_signal(
  input,
  outcome,
  type = "observed",
  resolution = "weeks",
  horizon = NULL
)
}
\arguments{
\item{input}{Data to be converted to signal; see "Details" for more information}

\item{outcome}{Name of the outcome column in the input data}

\item{type}{Signal type; must be one of "observed" or "forecast"; default is "observed"}

\item{resolution}{The temporal resolution of the signal; data can be aggregated daily, weekly, or monthly; default is \code{"weeks"}; see "Details" for more information}

\item{horizon}{Number of time steps ahead for forecast signals; only used if \code{type="forecast"}; default is \code{NULL}}
}
\value{
An object of the class \code{signal}. The object will have a second class of either \code{observed} or \code{forecast} depending on the value passed to the "type" argument.
}
\description{
This function creates an object of the S3 class "signal". The user can conditionally specify either a "forecast" or "observed" signal.
}
\details{
The input signal data may be either "observed" or "forecast" data. Depending on the type, the input data must conform to certain format prior to submission. In both cases, the data must be passed as a data frame.

For "observed" data the data frame must at minimum include columns for \strong{location} (geographic unit such as FIPS code) and \strong{date} (date of reported value; must be \code{date} class). The data should also include a column that contains the outcome (e.g., case count).

For "forecast" data the data frame must include columns for \strong{location} (geographic unit such as FIPS code), \strong{date} (date corresponding to forecast horizon; must be \code{date} class or character formatted as 'YYYY-MM-DD'), \strong{horizon} (forecast horizon), \strong{lower} (the lower limit of the prediction interval for the forecast), \strong{point} (the point estimate for the forecast), and \strong{upper} (the upper limit of the prediction interval for the forecast). Note that the \link{read_forecast} function returns data in this format.

The input data must at the daily, weekly, or monthly resolution. The "resolution" parameter is designed to use string matching. This allows flexibility for the user, such that, for example, an input of "day", "days", or "daily" would all resolve to a resolution of \emph{days}. The same rules apply for designating weekly or monthly resolution.
}
\examples{
hosp <- read.csv(system.file("extdata/observed/hdgov_hosp_weekly.csv", package = "rplanes"))
to_signal(hosp, outcome = "flu.admits", type = "observed", resolution = "weeks")

fp <- system.file("extdata/forecast/2022-10-31-SigSci-TSENS.csv", package = "rplanes")
ex_forecast <- read_forecast(fp)
to_signal(ex_forecast, outcome = "flu.admits", type = "forecast", horizon = 4, resolution = "weeks")
}
