% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plec-function.R
\name{plec}
\alias{plec}
\title{Estimate DNA-methylation-based gestational age}
\usage{
plec(norm_beta, type = "stack", verbose = FALSE)
}
\arguments{
\item{norm_beta}{A data frame of normalized beta values where each column
represents a sample and each row represent a probe. This data frame must be
the output of \code{\link{bmiq_norm_450k}} function. The rows must be named
according to the probe IDs. Meanwhile, the columns must be named according to
the sample IDs.}

\item{type}{An character indicating the type of outputs which are primarily:
(1) "stack" (default) for the estimated GA; (2) "normal" for the estimated
normal GA; (3) "residual" for the estimated residual GA; (4)
"condition" for the condition-specific, estimated residual GA; and (5)
"trimester" for the trimester-specific, estimated residual GA. In addition,
a user can obtain the output of a single submodel using the column name
(except \code{predictor}) in \code{plec_int_coef}. Use \code{data(plec_int_coef)} to
load this data frame.}

\item{verbose}{A logical scalar indicating whether to show a progress bar.}
}
\value{
A data frame of the estimated GA.
}
\description{
This function estimate gestational age (GA) using BMIQ-normalized beta
values. The estimated GA is a sum of normal and residual GAs. The latter
is a sum of condition- and trimester-specific, residual GAs.
}
\examples{

\donttest{
  beta_values_case <- download_beta_values_case()
  norm_beta_values_case <- bmiq_norm_450k(beta_values_case)
  dnam_ga_case <- plec(norm_beta_values_case)
}
}
\keyword{gestational-age}
\keyword{placental-epigenetic-clock}
\keyword{predict}
