% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_brain_image.R
\name{antspynet_preprocess_brain_image}
\alias{antspynet_preprocess_brain_image}
\title{Process brain image prior to segmentation}
\usage{
antspynet_preprocess_brain_image(
  x,
  truncate_intensity = c(0.01, 0.99),
  brain_extraction_modality = c("none", "t1", "t1v0", "t1nobrainer", "t1combined",
    "flair", "t2", "bold", "fa", "t1infant", "t2infant"),
  template_transform_type = c("None", "Affine", "Rigid"),
  template = c("biobank", "croppedMni152"),
  do_bias_correction = TRUE,
  return_bias_field = FALSE,
  do_denoising = TRUE,
  intensity_matching_type = c("regression", "histogram"),
  reference_image = NULL,
  intensity_normalization_type = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{\code{'ANTsImage'} or path to image to process}

\item{truncate_intensity}{defines the quantile threshold for truncating the
image intensity}

\item{brain_extraction_modality}{character of length 1, perform brain
extraction modality}

\item{template_transform_type}{either \code{'Rigid'} or \code{'Affine'}
align to template brain}

\item{template}{template image (not skull-stripped) or string, e.g.
\code{'biobank'}, \code{'croppedMni152'}}

\item{do_bias_correction}{whether to perform bias field correction}

\item{return_bias_field}{return bias field as an additional output without
bias correcting the image}

\item{do_denoising}{whether to remove noises using non-local means}

\item{intensity_matching_type}{either \code{'regression'} or
\code{'histogram'}; only is performed if \code{reference_image} is not
\code{NULL}.}

\item{reference_image}{\code{'ANTsImage'} or path to image, or \code{NULL}}

\item{intensity_normalization_type}{either re-scale the intensities to
\code{c(0, 1)} (\code{'01'}), or for zero-mean, unit variance
(\code{'0mean'}); if \code{NULL} normalization is not performed}

\item{verbose}{print progress to the screen}
}
\value{
Dictionary with images after process. The images are registered and
re-sampled into template.
}
\description{
Strip skulls, normalize intensity, align and re-sample to template. This
procedure is needed for many \code{antspynet} functions since the deep
neural networks are trained in template spaces
}
\examples{

library(rpyANTs)
if(interactive() && ants_available("antspynet")) {
  image_path <- ants$get_ants_data('r30')
  preprocessed <- antspynet_preprocess_brain_image(
    image_path, verbose = FALSE
  )

  # Compare
  orig_img <- as_ANTsImage(image_path)
  new_img <- preprocessed$preprocessed_image
  pal <- grDevices::gray.colors(256, start = 0, end = 1)

  par(mfrow = c(1, 2), mar = c(0.1, 0.1, 0.1, 0.1),
      bg = "black", fg = "white")
  image(orig_img[], asp = 1, axes = FALSE,
        col = pal, ylim = c(1, 0))
  image(new_img[], asp = 1, axes = FALSE,
        col = pal, ylim = c(1, 0))

}


}
\seealso{
\code{antspynet$preprocess_brain_image}
}
