% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rqcan1}
\alias{rqcan1}
\title{First Component}
\usage{
rqcan1(X, Y, tau = 0.5, a.pos = 1, wts = rep(1, nrow(X)))
}
\arguments{
\item{X}{input X-matrix}

\item{Y}{input Y-matrix}

\item{tau}{probability for qualtile (default = .5)}

\item{a.pos}{indices of Y-variable whose coefficient is constrained to be positive (default = 1)}

\item{wts}{case weights (default = rep(1,nrow(X)) ) \cr}
}
\value{
Returns list(a,X,Y,a.pos,R,r,rho1): a = output from rq.fit.fnc(XY,y0,R,r,tau) ; X,Y,a.pos = input data ; R,r = constraint matrices for rq.fit.fnc ; rho1 = rq objective fct. ; if rq.fit.fnc generates a singular matrix, returns "sing" \cr
\cr
}
\description{
Internal function to find the first component \cr
 It is not intended for general use, but the documentation may be helpful if errors occur or if one whishes to modify the algorithms 
\cr
}
\details{
The function finds the leading pair of indices. Notes: an intercept is added  (X should not include 1st col = 1) ;  ncol(Y) should be > 1 ; length(a.pos) should be at least 1 to specify coef signs (if tau = .5 and a.pos = NULL,  coef and -coef give the same solution) ; for length(a.pos) < ncol(Y), the constraint  sum(|alpha|) = 1  is set by setting Y1_j =  s_j Y_j  (j !in a.pos) where s_j = sgn(alpha_j) ;  all sign choices are used and then constrained rq.fit.fnc( cbind(1,X,Y1),y0=0,R,r,tau) is applied \cr (R,r) contrains all alpha_j >= 0 and sum(alpha_j) >= 1 (makes sum = 1)
}
